# Cookbook with Hugo

Ce dossier permet de créer un livre de recettes en deux formats : une version en ligne (site web) et une version imprimée.

Le CMS [hugo](https://gohugo.io/) est utilisé pour générer les templates HTML des deux versions, tandis que [Paged.js](https://pagedjs.org/) est intégré pour appliquer du CSS et adapter le rendu à l'impression.

Ce projet a été développé par Julie Blanc dans un but pédagogique.

**Versions**

- v1 → Module de recherche Création, École nationale supérieure des Arts Décoratifs, 2024

**Lien du repo**

[https://gitlab.com/julieblanc-workshops/cookbook-with-hugo](https://gitlab.com/julieblanc-workshops/cookbook-with-hugo)


**Informations**

- Développé avec Hugo v0.136.5 et Paged.js 0.4.3
- MIT License
- Cookbook inspiré par [Julien Bidoret](https://ateliers.esad-pyrenees.fr/web/pages/exemples/cookbook/)


## Installer Hugo

### MAC OS

Si vous ne l’avez jamais fait, installez Homebrew dans votre terminal (cela peut prendre un peu de temps). Ouvrez votre terminal et tapez:

```
/bin/bash -c "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/HEAD/install.sh)"
```

Fermez complètement votre terminal puis re-ouvrez-le. Installez Hugo en tapant:

```
brew install hugo
```

### Windows

Attention: Hugo v0.121.1 et versions ultérieures nécessitent au moins Windows 10 ou Windows Server 2016.

Si vous ne l’avez jamais fait, installez Chocolatey en suivant les instructions suivantes: https://chocolatey.org/install

Ouvrez votre Terminal (ou Shell) et installez Hugo en tapant:

```
choco install hugo-extended
```



## Utiliser hugo dans le terminal

Avant de commencer à faire quoi que ce soit, dans le terminal aller à l’emplacement du dossier du site:

```
cd path/to/cookbook-with-hugo
```

### Lancer le site

```
hugo serve
```

La première fois, cela va créer dans votre dossier un nouveau sous-dossier "public", il ne faut pas toucher ce dossier.


### Créer une nouvelle recette

```
hugo new recettes/nom-recette.md
```

Attention, dans le nom de la recette, il ne faut pas mettre d’espace ni de caractère spéciaux.

Aller ensuite dans le sous-dossier "content/recettes" et trouver le nouveau fichier qui a été créé, le remplir.


## Les sous-dossiers

### Archetypes

Vous n’aurez pas besoin de toucher ce sous-dossier. À l’intérieur se trouve le template qui va permettre de créer un nouveau fichier markdown pour les recettes.


### Assets

À l’intérieur se trouve les feuilles de styles pour votre CSS.

- `style-print.css` → la feuille de style pour la version imprimée
- `style-screen.css` → la feuille de style pour le site web à l’écran
- `ſonts.css` → le fichier pour ajouter vos polices de caractères

Pour les polices de caractères, ajouter vos dossier de la police de caractère avec son `stylesheet.css` dans le dossier `static/fonts`.
Puis ajouté le lien vers ce stylesheet dans le fichier `font.css`.

Comme cet exemple:

```
@import url("/fonts/lobular/stylesheet.css");
```

### Content

C’est là que se trouve le contenu de votre site. Les contenus sont écrits en markdown (`.md`), un langage très simple, plus facile à érire que le HTML. 

En haut du fichier, tout ce qui se trouve entre les deux `---` s’appelle le frontmatter. C’est là que l’on ajoute du contenu déjà structuré, qui ira dans des endroits spécifiques de l’HTML (title, author, etc.). Il faut le remplir tel qu’il est donné et faire attention aux guillements.

Tout ce qui se trouve après le frontmatter est du contenu markdown est libre. Ce qui est écrit en markdown sera ensuite transformé en HTML. Ce fichier d’explication est écrit en Markdown.

Markdown est un  langage de balisage léger, très largement utilisé et documenté partout sur le web. Il est utilisé pour structurer des contenus qui seront ensuite transformé en HTML et il est plus facile à utiliser que le HTML.

Par exemple, si on écrit ceci en Markdown:

```
## Mon titre

Ceci est une phrase.

Ceci est une deuxième phrase.
```

Cela deviendra en HTML:

```
<h2>Mon titre</h2>
<p>Ceci est une phrase.</p>
<p>Ceci est une deuxième phrase.</p>
```

Les autres syntaxes de markdown sont expliquées ici: [https://esadpyrenees.github.io/PageTypeToPrint/markdown/](https://esadpyrenees.github.io/PageTypeToPrint/markdown/)

Et pour plus d’informations voir [Wikipédia](https://fr.wikipedia.org/wiki/Markdown#:~:text=Markdown%20est%20un%20langage%20de,l'%C3%A9tat%2C%20sans%20formatage)



Les dossiers et fichiers dans `content`:

- **Recettes** → Ce sont les recettes qui vont apparaître sur le site, un fichier Markdown va créer une page HTML correspondante.
Cela va aussi ajouter la recette dans la version imprimée.
- **about.md** → Vous pouvez écrire ici ce qui va apparaître dans la page about (à propos). Il est possible de changer le titre.
- **home.md** → Vous pouvez écrire ici ce qui va apparaître en haut de la page d’accueil.
- **print.md** → Dans ce fichier, il y a seulement un frontmatter où vous pouvez modifier les éléments qui apparaîtront sur la couverture de votre livre.


### layouts

C’est le dossier qui contient vos templates HTML dans lesquels vont se mettre automatiquement les éléments de vos fichiers markdown. Il ne vaut mieux pas le toucher pour le moment.


### Public

Ce dossier sera créer la première fois que vous lancerez Hugo. Il contient tout votre site généré.
Attention, il ne faut jamais le toucher. 


### Static

Dans ce dossier, vous pouvez mettre vos images (sous-dossier `images`) et vos polices de caractères (sous-dossier `fonts`).

Ne pas oublier d’ajouter le lien vers les `stylesheet.css` de vos polices dans le fichier `assets/font.css`.


### hugo.toml

C’est le fichier de configuration du site. Vous pouvez changer le titre général du site et l’auteur. Attention à bien respecter els indentations et les guillemets.